package gov.cms.grouper.snf.model;

import java.util.HashMap;
import java.util.Map;

/**
 * Clinical categories of the ICD-10CM diagnosis codes
 */
public enum ClinicalCategory {
  ACUTE_INFECTIONS("Acute Infections"),
  ACUTE_NEUROLOGIC("Acute Neurologic"),
  CANCER("Cancer"),
  CARDIOVASCULAR_AND_COAGULATIONS("Cardiovascular and Coagulations"),
  MAJOR_JOINT_REPLACEMENT_OR_SPINAL_SURGERY("Major Joint Replacement or Spinal Surgery"),
  MEDICAL_MANAGEMENT("Medical Management"),
  NON_NEUROLOGIC("Non Neurologic"),
  NON_ORTHOPEDIC_SURGERY("Non-Orthopedic Surgery"),
  NON_SURGICAL_ORTHOPEDIC_MUSCULOSKELETAL("Non-Surgical Orthopedic/Musculoskeletal"),
  ORTHOPEDIC_SURGERY("Orthopedic Surgery (Except Major Joint Replacement or Spinal Surgery)"),
  OTHER_ORTHOPEDIC("Other Orthopedic"),
  PULMONARY("Pulmonary"),
  RETURN_TO_PROVIDER("Return to Provider");

  // Cache the list of enums
  private static final Map<String, ClinicalCategory> cache = new HashMap<>();
  private String description;

  ClinicalCategory(String description) {
    this.description = description;
  }

  public String getDescription() {
    return description;
  }

  public static ClinicalCategory of(String description) {
    if (ClinicalCategory.cache.isEmpty()) {
      for (ClinicalCategory category : ClinicalCategory.values()) {
        ClinicalCategory.cache.put(category.getDescription(), category);
      }
    }

    return cache.get(description);
  }
}
